package gov.va.med.mhv.bluebutton.web.bean;

import gov.va.med.mhv.bluebutton.transfer.SendRequestsStatusDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.bean.ManagedBean;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;


@ManagedBean
@Component
@Scope("session")
public class SendRequestsStatusBean implements Serializable {
	private static final long serialVersionUID = 3132557745182208084L;

	private List<SendRequestsStatusDTO> requestsStatusList;
	private Long userProfileID = null;
	private Boolean isBasicUser = null;
	private Boolean isStatusListEmpty = null;
	private Boolean showNothingFoundMsg = new Boolean(false);
	private Boolean showServiceUnavailableMsg = new Boolean(false);
		
	
	public void setSendRequestsStatusList(List<SendRequestsStatusDTO> requestsStatusList) {
		this.requestsStatusList = requestsStatusList;
	}
	
	public void setSendRequestsStatusListWithDirectMessages(List<DirectMessageDTO> directMessagesList) {
		List<SendRequestsStatusDTO> sendRequestsStatusList = new ArrayList<SendRequestsStatusDTO>();
		
		if (directMessagesList != null) {
			for (DirectMessageDTO directMessage : directMessagesList) {
				SendRequestsStatusDTO sendRequestsStatusDTO = new SendRequestsStatusDTO(directMessage);				
				sendRequestsStatusList.add(sendRequestsStatusDTO);
			}
		}

		this.requestsStatusList = sendRequestsStatusList;
	}
	
	public List<SendRequestsStatusDTO> getSendRequestsStatusList() {
		return requestsStatusList;
	}
	
	
	public void setIsBasicUser(Boolean isBasicUser) {
		this.isBasicUser = isBasicUser;
	}

	public Boolean getIsBasicUser() {
		return isBasicUser;
	}

	
	public void setUserProfileID(Long userProfileID) {
		this.userProfileID = userProfileID;
	}

	public Long getUserProfileID() {
		return userProfileID;
	}

	
	public Boolean getIsRequestsStatusListEmpty() {
		return isStatusListEmpty;
	}
	
	public void setIsRequestsStatusListEmpty(Boolean isStatusListEmpty) {
		this.isStatusListEmpty = isStatusListEmpty;
	}
	
	public void setShowNothingFoundMsg(Boolean showNothingFoundMsg) {
		this.showNothingFoundMsg = showNothingFoundMsg;
	}
	
	public Boolean getShowNothingFoundMsg() throws MHVException {
		return new Boolean(!getIsBasicUser().booleanValue() && showNothingFoundMsg);
	}
	
	
	public void setShowServiceUnavailableMsg(Boolean showServiceUnavailableMsg)  {
		this.showServiceUnavailableMsg = showServiceUnavailableMsg;
	}
	
	public Boolean getShowServiceUnavailableMsg() throws MHVException {
		return new Boolean(!getIsBasicUser().booleanValue() && showServiceUnavailableMsg);
	}
}
